import { NavigationLink } from "@/components/layout/navigation.link";
import { Button } from "@/components/ui/button";
import { cn } from "@/lib/utils";
import { ArrowRightIcon } from "@radix-ui/react-icons";

export function LoginSsoCognito({ className }: { className?: string }) {
  return (
    <NavigationLink
      href={"/api/login"}
    >
      <Button
        variant={"expandIcon"}
        iconPlacement="right"
        Icon={ArrowRightIcon}
        className={cn("gap-2", className)}
      >
        Continue to login
      </Button>
    </NavigationLink>
  )
}
